************************************************************************
*This program calculates household superannuation balances from l SIH person-level 2017/18  data 
*The output is used for cross-sectional analysis 
**********************************************
clear
*import 2017/18 person-level data 
use "$path\rawdata\SIH17BP.dta"

egen hh_super_balance= sum(vsuptot), by(abshid)
label variable hh_super_balance "HH balance of total super accounts "


egen hh_super_noincome=sum(supbalnp), by(abshid)
label variable hh_super_noincome "HH balance of super accounts that pay no income "


egen hh_super_income=sum(supbalp), by(abshid)
label variable hh_super_income "HH balance of super accounts that pay income "


gen liquid_super=0
replace liquid_super=vsuptot if supbalp>0

gen illiquid_super=0
replace illiquid_super=vsuptot if supbalp==0

egen hh_liquid_super=sum(liquid_super), by(abshid)
egen hh_illiquid_super=sum(illiquid_super), by(abshid)


*get rid of duplications 
sort abshid
by abshid:  gen dup_hh = cond(_N==1,0,_n)
drop if dup_hh>1
drop dup_hh

keep abshid hh_super_balance hh_super_income hh_super_noincome  hh_liquid_super hh_illiquid_super

save "$path\data\SIH17BP_household_super.dta"
